<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class ChangeDashboardFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $blocks = [
            'Manufactured batches',
            'API stock on site',
            'Open invoices',
            'Released batches',
            'Release leadtimes',
            'Key facts',
            'Open deviations',
            'Open complaints',
            'Forecast accuracy',
            'Manufactured YTD',
            'Manufactured YTG'
        ];
        $i = 1;
        $weight = 0;

        foreach ($blocks as $block) {
            $this->bridge->contentTypeDeleteField('node', 'dashboards', 'block_' . $i . '_content');

            $weight += 7;
            $fields = [
                [
                    'name' => 'block_' . $i . '_modal_text',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'required' => false,
                    'weight' => $weight,
                    'title' => [
                        'en' => 'Read more - text',
                        'fr' => 'En savoir plus - texte',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::WYSIWYG_WIDGET,
                        'settings' => [],
                        'weight' => $weight++,
                        'group' => 'group_block_' . $i
                    ],
                    'type' => BridgeContentType::WYSIWYG_FIELD,
                    'settings' => [
                        'cardinality' => 1,
                    ],
                ],
                [
                    'name' => 'block_' . $i . '_modal_file',
                    'searchable' => true,
                    'search_result_field' => true,
                    'required' => false,
                    'weight' => $weight,
                    'title' => [
                        'en' => 'Read more - file',
                        'fr' => 'En savoir plus - fichier'
                    ],
                    'widget' => [
                        'type' => BridgeContentType::FILE_WIDGET,
                        'settings' => [
                            'progress_indicator' => 'throbber',
                        ],
                        'weight' => $weight++,
                        'group' => 'group_block_' . $i
                    ],
                    'type' => BridgeContentType::FILE_FIELD,
                    'settings' => [
                        'display_field' => false,
                        'display_default' => false,
                        'uri_scheme' => 'public',
                        'target_type' => 'file',
                        'cardinality' => 1,
                    ],
                ]
            ];

            foreach ($fields as $field) {
                $this->bridge->contentTypeCreateOrUpdateField('dashboards', $field['name'], $field);
            }

            $i++;
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
